//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct stComplex
{
//+----------------+
    private :
        double m_r, m_i;
//+----------------+
    public  :
//+----------------+
        stComplex(): m_r(0), m_i(0) {}
//+----------------+
        stComplex(double r, double i): m_r(r), m_i(i) {}
//+----------------+
        stComplex operator+(const stComplex &arg1)
        {
            return stComplex(m_r + arg1.m_r, m_i + arg1.m_i);
        }
//+----------------+
        stComplex operator+(const double arg2)
        {
            return stComplex(m_r + arg2, m_i);
        }
//+----------------+
        stComplex operator+=(const double arg2)
        {
            return stComplex(m_r += arg2, m_i);
        }
//+----------------+
        void Debug(void)
        {
            PrintFormat("Internal Value = %.02f %c %.02fi", m_r, (m_i < 0 ? '-' : '+'), MathAbs(m_i));
        }
//+----------------+
};
//+------------------------------------------------------------------+
void OnStart(void)
{
    stComplex   a(2, 5),
                b(8, -3),
                c;

    c = a + b;
    c.Debug();

    (c += 4).Debug();
    c = b + 4;
    c.Debug();
}
//+------------------------------------------------------------------+